/// @description Insert description here
// You can write your code in this editor
var _octaves = 3;

for(var _x = 0; _x < room_width; _x += WALL_WIDTH)
{
	instance_create(_x, 0, oWall);
	instance_create(_x, room_height - WALL_HEIGHT, oWall);
}

for(var _y = WALL_HEIGHT; _y < room_height - WALL_HEIGHT; _y += WALL_HEIGHT)
{
	instance_create(0, _y, oWall);
	instance_create(room_width - WALL_WIDTH, _y, oWall);
}

var _roomWidth = round(room_width / 16);
var _roomHeight = round(room_height / 16);
var _posX = round(_roomWidth/2);
var _posY = round(_roomHeight/2);

var _hcells = room_width div WALL_WIDTH;
var _vcells = room_height div WALL_HEIGHT;
//global.mpGrid = mp_grid_create(0, 0, _hcells, _vcells, WALL_WIDTH, WALL_HEIGHT);

//Add the walls
//mp_grid_add_instances(global.mpGrid, oWall, false);

//oCamera.followingObject = _player;
/*with(oCamera)
{
	followingObject = _player;
	//camera_set_view_pos(camera, _player.x, _player.y);
}*/

var _layId = layer_get_id("TileFloor");
var _mapId = layer_tilemap_get_id(_layId);
var _topLayId = layer_get_id("TileWallTop");
var _topMapId = layer_tilemap_get_id(_topLayId);

var _generationAmount = 5000;
var _dir = 0;
var _generateWidth = 4;
var _generateHeight = 4;
var _odds = 3;
var _spawnerOdds = 10;

repeat(_generationAmount)
{
	//Sets the tiles
	for(var i = 0; i < _generateWidth; i++)
	{
		for(var j = 0; j < _generateHeight; j++)
		{
			tilemap_set(_mapId, choose(1, 2, 3), _posX + i, _posY + j);
		}
	}
	
	if(!instance_exists(oPlayer))
	{
		var _player = instance_create((_posX+1)*16, (_posY+1)*16, oPlayer);
	}
	
	if(irandom(_spawnerOdds) == _spawnerOdds) instance_create((_posX+1)*16, (_posY+1)*16, oEnemySpawner);
	
	if(irandom(_odds) == _odds) _dir = choose(0, 1, 2, 3);
	_posX += lengthdir_x(1, _dir*90);
	_posY += lengthdir_y(1, _dir*90);
	while(_posX <= 0 || _posX >= _roomWidth - _generateWidth-1 || _posY <= 0 || _posY >= _roomHeight - _generateHeight-1)
	{
		_posX -= lengthdir_x(1, _dir*90);
		_posY -= lengthdir_y(1, _dir*90);
		_dir = choose(0, 1, 2, 3);
		_posX += lengthdir_x(1, _dir*90);
		_posY += lengthdir_y(1, _dir*90);
	}
}

for(var _x = WALL_WIDTH; _x < room_width - WALL_WIDTH; _x += WALL_WIDTH)
{
	for(var _y = WALL_HEIGHT; _y < room_height - WALL_HEIGHT; _y += WALL_HEIGHT)
	{
		var _count = 0;
		var _midValue = 1;
		for(var i = 0; i < 3; i++)
		{
			for(var j = 0; j < 3; j++)
			{
				if(i != 0 || j != 0)
				{
					if(tilemap_get_at_pixel(_mapId, _x + ((i-_midValue)*WALL_WIDTH), _y + ((j-_midValue)*WALL_HEIGHT)) >= 1)
					{
						_count++;
					}
				}
			}
		}
		if(tilemap_get_at_pixel(_mapId, _x, _y) < 1)
		{
			if(_count > 0)
			{
				instance_create(_x, _y, oWall);
			}
			else if(position_meeting(_x, _y - WALL_HEIGHT, oWall))
			{
				//instance_create(_x, _y, oTopWall);
				tilemap_set_at_pixel(_topMapId, 1, _x, _y);
			}
		}
	}
}

/*with(oWall)
{
	var _count = 0;
	for(var _x = 0; _x < 3; _x++)
	{
		for(var _y = 0; _y < 3; _y++)
		{
			if(_x != 0 || _y != 0)
			{
				var _midX = 1, _midY = 1;
				if(tilemap_get_at_pixel(_mapId, x + ((_x-_midX)*WALL_WIDTH), y + ((_y-_midY)*WALL_HEIGHT)) != 1)
				{
					_count++;
				}
			}
		}
	}
	if(_count == 8) instance_destroy();
}